package org.amse.mm.io;

import java.io.*;

import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;
import org.amse.mm.myVirtualBilliards.model.*;
import org.w3c.dom.*;

public class XMLWriter {
	private ITable myTable;
	
	private Document makeDocBalls() throws IOException, ParserConfigurationException {
		
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder parser = factory.newDocumentBuilder();
		Document doc = parser.newDocument();
		Node root = doc.createElement("balls");
		doc.appendChild(root);
		
		
		for (IBall ball: myTable.balls()) {
			Element element = doc.createElement("ball");
			element.setAttribute("color", ball.getColor().toString());
		//	element.setAttribute("x", String.valueOf(formatter.format("%6.3f", ball.getCoordinate().X)));
//			formatter = new Formatter();
//			element.setAttribute("y", String.valueOf(formatter.format("%6.3f", ball.getCoordinate().Y)));
			element.setAttribute("x", String.valueOf(formatNumber(ball.getCoordinate().X)));
			element.setAttribute("y", String.valueOf(formatNumber(ball.getCoordinate().Y)));
			root.appendChild(element);
		}	
		return doc;
	}
	
	private Document makeDocProperty() throws IOException, ParserConfigurationException {
		
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder parser = factory.newDocumentBuilder();
		Document doc = parser.newDocument();
		Node root = doc.createElement("property");
		doc.appendChild(root);
		
		Element element = doc.createElement("friction");
		element.setAttribute("value", String.valueOf(myTable.getFriction()));
		root.appendChild(element);
		
		return doc;
	}
	
	private double formatNumber(double d){
		int i = (int)((d * 1000) / 1);
		return (double)i / 1000;
	}
	
	public void write(ITable table, OutputStream stream, boolean areBalls) {
		myTable = table;
		try {
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer transformer = tf.newTransformer();
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			
			Document document;
			if (areBalls){
				document = this.makeDocBalls();
			}else{
				document = this.makeDocProperty();
			}
						
			DOMSource source = new DOMSource(document);
			StreamResult result = new StreamResult(stream);
			
			transformer.transform(source, result);
			
		} catch (ParserConfigurationException e) {
			System.out.println(e.getMessage());
		} catch (IOException e1) {
			System.out.println(e1.getMessage());
		} catch (TransformerConfigurationException e2) {
			System.out.println(e2.getMessage());
		} catch (TransformerException e3) {
			System.out.println(e3.getMessage());
		}
	}

}
